'use strict';

/* --------------------------------------------------------------
 datatable_loading_spinner.js 2017-03-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Enable DataTable Loading Spinner
 *
 * The loading spinner will be visible during every DataTable AJAX request.
 *
 * ### Options
 *
 * ** Z-Index Reference Selector | `data-datatable_loading_spinner-z-index-reference-selector` | String | Optional**
 * Provide a reference selector that will be used as a z-index reference. Defaults to ".table-fixed-header thead.fixed".
 *
 * @module Admin/Extensions/datatable_loading_spinner
 */
gx.extensions.module('datatable_loading_spinner', ['loading_spinner'], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Default Options
     *
     * @type {Object}
     */
    var defaults = {
        zIndexReferenceSelector: '.table-fixed-header thead.fixed'
    };

    /**
     * Final Options
     *
     * @type {Object}
     */
    var options = $.extend(true, {}, defaults, data);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    /**
     * Loading Spinner Selector
     *
     * @type {jQuery}
     */
    var $spinner = void 0;

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * On Pre DataTable XHR Event
     *
     * Display the loading spinner on the table.
     */
    function _onDataTablePreXhr() {
        var zIndex = parseInt($(options.zIndexReferenceSelector).css('z-index'));
        $spinner = jse.libs.loading_spinner.show($this, zIndex);
    }

    /**
     * On XHR DataTable Event
     *
     * Hide the displayed loading spinner.
     */
    function _onDataTableXhr() {
        if ($spinner) {
            jse.libs.loading_spinner.hide($spinner);
        }
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('preXhr.dt', _onDataTablePreXhr).on('xhr.dt', _onDataTableXhr);

        $(window).on('JSENGINE_INIT_FINISHED', function () {
            _onDataTablePreXhr();

            // Hide the spinner if the table is already loaded.
            if ($this.DataTable().ajax.json() !== undefined) {
                _onDataTableXhr();
            }
        });

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
